//
//  MCEntityInfoRegistry.h
//  MCFoundation
//
//  Created by Ali Lalani on 26/11/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPEntity;
@interface MCEntityInfoRegistry : NSObject {
	NSMutableDictionary *__entities;
}
+ (MCEntityInfoRegistry *)defaultRegistry;

#pragma mark Registration
- (void)registerEntityConfigurations:(NSArray *)entityConfigs;
- (void)registerEntityConfiguration:(NSDictionary *)config;

#pragma mark Conveniences
- (NSDictionary *)configurationForEntity:(MCPEntity *)anEntity;
- (NSDictionary *)configurationForEntityNamed:(NSString *)anEntityName;
- (NSArray *)linkableEntityNamesForEntity:(MCPEntity *)anEntity;
- (NSArray *)linkableEntityNamesForEntityNamed:(NSString *)anEntityName;


#pragma mark Accessors
- (NSMutableDictionary *)entities;
- (void)setEntities:(NSMutableDictionary *)anEntities;
@end
